//
//  GSRandomNumberGenerator.h
//  GlyphsKit
//
//  Created by Florian Pircher on 2025-05-17.
//  Copyright © 2025 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface GSRandomNumberGenerator : NSObject

/// Produces a seed specific to the given string.
///
/// This seed is not cryptographically secure, uniform, or otherwise suitable as a hash value.
/// It can be used as a seed for random number generation of insecure RNG sequences.
+ (uint64_t)seedForString:(NSString *)string;

/// Creates an insecure RNG with a pseudo-random seed.
- (instancetype)init NS_DESIGNATED_INITIALIZER;
/// Creates an insecure RNG with the given seed.
- (instancetype)initWithSeed:(uint64_t)seed NS_DESIGNATED_INITIALIZER;

/// Resets the state of the RNG to a pseudo-random seed.
- (void)resetWithRandomSeed;
/// Resets the state of the RNG to the given seed.
- (void)resetWithSeed:(uint64_t)seed;

/// Returns a random Boolean and advances the random number generator.
- (BOOL)nextBool;
/// Returns a unsigned integer in the range `[0, bound)` and advances the random number generator.
///
/// - Parameter bound: Upper limit (exclusive).
- (uint32_t)nextInt:(uint32_t)bound;

@end

NS_ASSUME_NONNULL_END
